/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
pelvis_score();

/**
 * Performs the pelvis score calculation for the specified models
 */
function pelvis_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();
    let body_region_label = "pelvis";

    let occupants = ["DRIVER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            let pelvis_force = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_PELVIS_FORCE_MAX_VALUE`,
                "float",
                templ
            );
            let pelvis_score = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_PELVIS_FORCE_SCORE`,
                "float",
                templ
            );

            let PELVIS_PUBIC_SYMPHYSIS = 2.8; //kN

            /** if pelvis_and_lumbar_modifier returned NaN then it means that data is missing for at least one of the values */

            new Variable(
                templ,
                `${m}_${occ}_PELVIS_SCORE`,
                `Result from Automotive Assessments Workflow`,
                pelvis_score.toString(),
                "General",
                false,
                true
            );
        }
    }
}
